#include <math.h>
#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>

//Equation for gate variables:

inline double x_inf(double v,double V12,double k) { return 1./(1.+exp(-(v-V12)/k)); }
inline double tau_inf(double tau,double v,double tauV12,double tauk) { return tau/(cosh((v-tauV12)/tauk)); }
inline double Gr(double v) { return 4.34e-5*exp(-0.0211539274*v); }//paper has error 4.34e5 should be e-5
inline double Gd1(double v) { return 0.075+0.043*tanh((v+20)-20); }
inline double Gv(double v) { return (10.6408- 14.6408*exp(-v/42.7671))/v; }


//NaF
const double mV12 = -43.8, mk = 6;
const double mtauV12 = -43.8, mtauk = 14;
const double hV12 = -67.5, hk = -10.8;
const double htau = 8.46, htauk = 12.8;
double gNaF = 150, htauV12 = -67.5, mtau = 0.25;

//NaP
const double mpV12 = -47.1, mpk = 3.1; 
const double mptau = 1, mptauV12 = -47.1, mptauk = 6.2;
double hpV12 = -60, hpk = -9;
const double hptau = 5000, hptauV12 = -60;
double GNAPBLK = 1, hptauk = 9;

//CaL
const double mcV12 = -27.5, mck = 5.7;//mcV12 = -40, mck = 4.0;//
const double mctau = 0.5;
const double hcV12 = -52.4, hck = -5.2;
const double hctau = 18;
//double gCa = .003;
double Caout=4, alphaCa=2.5e-5, tauCa=25, Cain0=0.0000000001, Cav=0; //tauCa was 50
double gCaL=0;
double Kpump=1e-3,Vpump=Kpump/tauCa;

//Kdr
const double   nAk = 5;
const double nB = 0.17, nBk = 40;
double gKdr = 160, nA = 0.01, nAV = 44, nBV = 49;

//CAN
double K_CAN = 0.74*1e-3, nc = 0.97, sigma_CAN=-0.05e-3;
double ECAN=0;
const double hcanC12 = .00015, hcank = -.0002;
const double hcantau = 100;

//ChR2
double Echr2 = 0;
double gma_chr2=0.1, eps1=0.8535, eps2=0.14;//Confirmed same as in williams 2013 -Williams 2013 values = gma_chr2=0.1, eps1=0.8535, eps2=0.14;
double sig_ret=1.0e-20, Gd2=0.05, tau_chr2=1.3;//Gd2 and tau_chr2 are the same; sig-ret varries between 1.2 and 12*10-20

//Arch
double Earch = -145;



double c=36;

//concentrations
double Nain=15, Naout = 120;
double Kin = 140, Kout = 4;                    

double ENa=26.54*log(Naout/Nain),EK=26.54*log(Kout/Kin);

const double Esyn=-10;


double rnd() {return double(rand())/RAND_MAX; }

double tausyn=5;

class Neuron
{
	public:

// parameters	

	double gCa,gNaP,gCAN,gChR2,gArch;
	double E_leak,g_L;

// dynamical variables

	double v;
	double m,h; // INaF
	double mp,hp; // INaP
	double mc,hc; // ICa
	double n; // IKdr
	double Cain;
	double Cav;
	double gsyn; 
	double Nain;
	double hcan;
	double OP1,OP2,CL1, CL2, Pchr2; //IChR2
	double Carch,Oarch,Iarch;//arch channel states

	Neuron();
	void init(double,double,double,double,double,double);
	void step(double dt,double drive,double fcan, double fsynCa, double irr);
	int spike(double vth,double dt,double drive,double fcan, double fsynCa, double irr);
};

struct connection
{
	int source,target;
	double weight;
};

class Population
{
	public:

	Neuron* net;
	int size;

	connection *w;
	int sex;

	double vth;
	
	Population(int n,double gca0,double gca1,double gl0,double gl1,double gnap0,double gnap1,
		double gcan0,double gcan1,double gchr20,double gchr21,double garch0,double garch1,double prob,double wght, double stimnum)
	{
		vth=-35;
		size=n;
		net=new Neuron [size];
		for(int i=0;i<size;i++)
		{	
			
                     
			net[i].gCa=gca0+(gca1-gca0)*rnd();
			net[i].gCAN=gcan0+(gcan1-gcan0)*rnd();
			net[i].gNaP=gnap0+(gnap1-gnap0)*rnd();
			net[i].g_L=gl0+(gl1-gl0)*rnd();
			net[i].gChR2=0.0;//rnd();
			net[i].gArch=0.0;//rnd();//Distrabution of I_Arch conductance
			net[i].gChR2=gchr20+(gchr21-gchr20)*rnd();//rnd();
			if (i <= stimnum){
			
			net[i].gArch=garch0+(garch1-garch0)*rnd();//rnd();//Distrabution of I_Arch conductance
			}
			//if (i > stimnum){
			//net[i].gChR2=0.0;//rnd();
			//net[i].gArch=0.0;//rnd();//Distrabution of I_Arch conductance
			//}
		}
		
		w=new connection [size*size];
		sex=0;
		for(int i=0;i<size;i++) for(int j=0;j<size;j++)
		{
			if(i==j || rnd()>prob) continue;
			w[sex].source=i;
			w[sex].target=j;
			w[sex].weight=wght*rnd();
			sex++;
		}
	}

	~Population() { delete w; delete net; }

	int step(double dt,double drive,int* spk,double fcan,double fw, double fsynCa, double irr)
	{
		int sp=0;
		for(int i=0;i<size;i++) { spk[i]=net[i].spike(vth,dt,drive,fcan,fsynCa,irr); sp+=spk[i]; }

		for(int i=0;i<sex;i++) if(spk[w[i].source]) net[w[i].target].gsyn+=w[i].weight*fw;

		return sp;
	}
};

Neuron::Neuron()
{
		v=-60; m=.1; h=.1; mp=.1; hp=.4*rnd(); n=.1; Cain=5*1e-5; Cav=5*1e-5; mc=.1; hc=.1;
		gCa=.003;
		gNaP=5;
		gCAN=1;
		gChR2=0.4;
		gArch=0.4;
		E_leak=-68; g_L=2.5;
		hcan=1;
		OP1 =0.00; OP2=0.00; CL1=0.99; CL2=0.01; Pchr2=0.1;
		Carch = 0.9; Oarch = 0.0;
}

int Neuron::spike(double vth,double dt,double drive,double fcan, double fsynCa, double irr)
{
		double vpre=v;
		step(dt,drive,fcan,fsynCa, irr);
		return (vpre<vth && v>=vth);
}

void Neuron::init(double gca,double glk,double gnap,double gcan,double gchr2,double garch)
{
	gCa=gca;
	g_L=glk;
	gNaP=gnap;
	gCAN=gcan;
	gChR2=gchr2;
	gArch=garch;
	m=rnd();
	h=rnd();
	mp=rnd();
	hp=rnd();
	mc=rnd();
	hc=rnd();
	n=rnd();
	Cain=5e-5*rnd();
	Cav=5e-5*rnd();
	OP1=0.00; OP2=0.00; CL1=0.99; CL2=0.01; Pchr2=0.1;
	Carch = 0.9; Oarch = 0.0;
}

int flag_hcan=0;

void Neuron::step(double dt,double drive,double fcan,double fsynCa, double irr)
{
	double ECa=26.54*log(Caout/Cain)/2;

	double INaF = gNaF*m*m*m*h;
	double INaP = gNaP*mp*hp*GNAPBLK;
	double ICa = gCa*mc*hc+gCaL;
	//ICa=0;
	double IChR2 = gChR2*Gv(v)*(OP1+gma_chr2*OP2)*(v-Echr2);
	double IArch = gArch*Oarch*(v-Earch);

	double k0 = v+nAV;
	double k1 = nA*k0/(1-exp(-k0/nAk));
	double k2 = nB*exp(-(v+nBV)/nBk);
	double taun_inf = 1/(k1+k2);
	double n_inf = k1/(k1+k2);

	double IKdr = gKdr*n*n*n*n;


	
    double ICAN = gCAN*fcan/(1.+pow(K_CAN/Cain,nc))*hcan; // Tporikova
//    double ICAN = gCAN/(1.+exp((Cain-K_CAN)/sigma_CAN)); // Rubin
	
	v+=(-INaF*(v-ENa)-INaP*(v-ENa)-IKdr*(v-EK)-ICAN*(v-ECAN)-ICa*(v-ECa)-IChR2-IArch-g_L*(v-E_leak)-(drive+gsyn)*(v-Esyn))/c*dt;

	m+=(x_inf(v,mV12,mk)-m)*(1.-exp(-dt/tau_inf(mtau,v,mtauV12,mtauk)));
	h+=(x_inf(v,hV12,hk)-h)*(1.-exp(-dt/tau_inf(htau,v,htauV12,htauk)));

	mp+=(x_inf(v,mpV12,mpk)-mp)*(1.-exp(-dt/tau_inf(mptau,v,mptauV12,mptauk)));
	hp+=(x_inf(v,hpV12,hpk)-hp)*(1.-exp(-dt/tau_inf(hptau,v,hptauV12,hptauk)));
	
	//if (irr>0){
	//hp=1;
	//}

	mc+=(x_inf(v,mcV12,mck)-mc)*(1.-exp(-dt/mctau));
	hc+=(x_inf(v,hcV12,hck)-hc)*(1.-exp(-dt/hctau));

	n+=(n_inf-n)*(1.-exp(-dt/taun_inf));
	
	//ChR2 gating variables
	if (gChR2 != 0)
		{
		double chr2irr = irr;
		if (irr <=0){chr2irr = 0;}
		double F = sig_ret*chr2irr*3.072772229e18;//last term = lamba/(w_loss*hc)
		double k1_chr2 = eps1*F*Pchr2;
		double k2_chr2 = eps2*F*Pchr2;
		double e12 = 0.011+ 0.005*log(1+chr2irr/0.024);
		double e21 = 0.008 + 0.004*log(1+chr2irr/0.024);
		double S0 = 0.5*(1+tanh(120*(100*chr2irr-0.1)));
		double dOP1 = (k1_chr2*CL1 + e21*OP2 - Gd1(v)*OP1 - e12*OP1 );
		double dOP2 = (k2_chr2*CL2 + e12*OP1 - Gd2*OP2 - e21*OP2);
		double dCL1 = (Gr(v)*CL2 + Gd1(v)*OP1 - k1_chr2*CL1);
		double dCL2 = (Gd2*OP2 - k2_chr2*CL2 - Gr(v)*CL2);
		OP1 += dt*dOP1;
		OP2 += dt*dOP2;
		CL1 += dt*dCL1;
		CL2 += dt*dCL2;
		Pchr2 += dt*((S0-Pchr2)/tau_chr2);
		}

	//Arch gating variables
	if (gArch != 0)
		{
		double archirr = irr;
		if (irr >=0){archirr = 0;}
		double dOarch = tanh(0.095*-1*archirr);
		Oarch += (dOarch-Oarch)*(1.-exp(-dt/25));//open state
		}

    Cain+=(-alphaCa*ICa*(v-ECa) - alphaCa*(gsyn)*fsynCa*(v-ECa) + (Cain0-Cain)/tauCa)*dt;//was at 3/100
    Cav+=(-alphaCa*ICa*(v-ECa) + (Cain0-Cav)/tauCa)*dt;//somatic/voltage gated ca transients

	if(flag_hcan){
			if((x_inf(Cain,hcanC12,hcank)-hcan)>0) hcan+=(x_inf(Cain,hcanC12,hcank)-hcan)*(1.-exp(-dt/8000));
			if((x_inf(Cain,hcanC12,hcank)-hcan)<0) hcan+=(x_inf(Cain,hcanC12,hcank)-hcan)*(1.-exp(-dt/.1));
			//if(Cain>0.0001) hcan = 0.00001;
			}

	gsyn*=exp(-dt/tausyn);
}

using namespace std;

ostream& operator <<(ostream& os,Neuron& N)
{
	return (os<<N.v<<'\t'<<N.m<<'\t'<<N.h<<'\t'<<N.mp<<'\t'<<N.hp<<'\t'<<N.n<<'\t'<<N.Cain);
}

istream& operator >>(istream& is,Neuron& N)
{
    return (is>>N.v>>N.m>>N.h>>N.mp>>N.hp>>N.n>>N.Cain);
}

ostream& operator <<(ostream& os,Population& p)
{
	for(int i=0;i<p.size;i++) os<<p.net[i]<<'\t';
	return os;
}

istream& operator >>(istream& is,Population& p)
{
	for(int i=0;i<p.size;i++) is>>p.net[i];
	return is;
}

int main(int argc,char** argv)
{
	//srand (clock());//setting the seed for rand()
	double dt=.05,T=10000;
	double DT=1;
	int size=100;
	double gca[2]={0.01,0.01},gleak[2]={2.5,2.5},gnap[2]={0,5},gcan[2]={1.0,1.0},prob=.1,wght=.1;
	double dr[2]={0,1},fc[2]={1,0},fcw[2]={1,1}, fsca[2]={0.01,0.01}, tauDrug = -5000, pctblk = 0, irrpower[2]={0.0,0.0}, gchr2[2] = {0.0,0.0}, garch[2] = {0.0,0.0};
	double pulseON=0, pulsefreq=0.0, pulsedur=100,pfmax =.25, pfmin=.25, dl=0.1, numdl=0, stimnum= 100, seed=0, max_gnap_blk=0.5;
	int ini=0, block_type = -9;
	char fname[256]="dat";
	int output=0;
	for(int i=1;i<argc;i++)
	{
		if(strcmp(argv[i],"-DT")==0) DT=atof(argv[++i]);
		else if(strcmp(argv[i],"-i")==0) ini=1;
		else if(strcmp(argv[i],"-hcan")==0) flag_hcan=1;
		else if(strcmp(argv[i],"-o")==0) output=1;
		else if(strcmp(argv[i],"-dt")==0) dt=atof(argv[++i]);
		else if(strcmp(argv[i],"-DT")==0) DT=atof(argv[++i]);
		else if(strcmp(argv[i],"-s")==0) size=atoi(argv[++i]);
		else if(strcmp(argv[i],"-T")==0) T=atof(argv[++i])*1000;
		else if(strcmp(argv[i],"-d")==0) { dr[0]=atof(argv[++i]); dr[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-w")==0) wght=atof(argv[++i]);
		else if(strcmp(argv[i],"-tgs")==0) tausyn=atof(argv[++i]);
		else if(strcmp(argv[i],"-nap")==0) { gnap[0]=atof(argv[++i]); gnap[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-na")==0) gNaF=atof(argv[++i]);
		else if(strcmp(argv[i],"-kdr")==0) gKdr=atof(argv[++i]);
		else if(strcmp(argv[i],"-ca")==0) { gca[0]=atof(argv[++i]); gca[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-glk")==0) { gleak[0]=atof(argv[++i]); gleak[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-cal")==0) gCaL=atof(argv[++i]);
		else if(strcmp(argv[i],"-tca")==0) tauCa=atof(argv[++i]);
		else if(strcmp(argv[i],"-kp")==0) Kpump=atof(argv[++i]);
		else if(strcmp(argv[i],"-vp")==0) Vpump=atof(argv[++i]);
		else if(strcmp(argv[i],"-kout")==0) Kout=atof(argv[++i]);
		else if(strcmp(argv[i],"-prob")==0) prob=atof(argv[++i]);
		else if(strcmp(argv[i],"-can")==0) { gcan[0]=atof(argv[++i]); gcan[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-fc")==0) { fc[0]=atof(argv[++i]); fc[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-fw")==0) { fcw[0]=atof(argv[++i]); fcw[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-fsca")==0) { fsca[0]=atof(argv[++i]); fsca[1]=atof(argv[++i]); }
		else if(strcmp(argv[i],"-ca0")==0) Cain0=atof(argv[++i]);
		else if(strcmp(argv[i],"-exp")==0) block_type=atof(argv[++i]); //1=can 2=TRPC3 
		else if(strcmp(argv[i],"-tauDrg")==0) tauDrug=atof(argv[++i]);//tau drug
		else if(strcmp(argv[i],"-sd")==0) seed=atof(argv[++i]);
		else if(strcmp(argv[i],"-scalegNaK")==0) {gNaF=gNaF*atof(argv[++i]); gKdr=gKdr*atof(argv[++i]);}
		else if(strcmp(argv[i],"-na_h12")==0) htauV12=atof(argv[++i]);
		else if(strcmp(argv[i],"-mtau")==0) mtau=atof(argv[++i]);
		else if(strcmp(argv[i],"-ktau")==0) nA=atof(argv[++i]);
		else if(strcmp(argv[i],"-pulsedur")==0) pulsedur=atof(argv[++i]);
		else if(strcmp(argv[i],"-K_v12")==0) {nAV=atof(argv[++i]); nBV=atof(argv[++i]);}
		else if(strcmp(argv[i],"-irr")==0) {irrpower[0]=atof(argv[++i]); irrpower[1]=atof(argv[++i]);}
		else if(strcmp(argv[i],"-irrfreq")==0) pulsefreq=atof(argv[++i]);
		else if(strcmp(argv[i],"-hp12")==0) {hpV12=atof(argv[++i]);}
		else if(strcmp(argv[i],"-gchr2")==0) {gchr2[0]=atof(argv[++i]); gchr2[1]=atof(argv[++i]);}
		else strcpy(fname,argv[i]);
	}

	if(seed !=0) srand (seed);
	int freq=int(DT/dt);


	pulseON = (1000/pulsefreq);
	Population pop(size,gca[0],gca[1],gleak[0],gleak[1],gnap[0],gnap[1],gcan[0],gcan[1],gchr2[0],gchr2[1],garch[0],garch[1],prob,wght,stimnum);
    	if(ini) { ifstream is("ini"); is>>pop; }
	ofstream out(fname);
	int sp=0;
	double irr=0;
	double laser = 0,l_on = 0, on_dur = 20, off_dur = 30;
	double laserpowers[6]={0.5,1.0,2.0,3.0,4.0,5.0};
	double laserpower=irrpower[0];
	double meanVm=0;
	int pulse_num = 0;

	for(double t=0;t<=T;t+=dt)
	{
		double drive=dr[1];//-t/T*(dr[1]-dr[0]);
		double fcan= fc[1];// -t/T*(fc[1]-fc[0]);
		double fw=fcw[1]-t/T*(fcw[1]-fcw[0]);
		double fsynCa=fsca[1]-t/T*(fsca[1]-fsca[0]);

		//double laserpower=irrpower[0]+t/T*(irrpower[1]-irrpower[0]);
		
		if (block_type == 1){
		double laserpower=laserpowers[pulse_num];
		}

		

		//sets 20Hz freq. in laser stim
		l_on +=dt;
		if (l_on >= (on_dur+off_dur))
		{
		laser = laserpower;// irrpower[0];
		l_on = 0;
		}
		if (l_on >= on_dur)
		{
		laser = 0;
		}

		int spk[size];

//////////////////////////////////////////////////////////////////////////////////
//opto stim protocol
//////////////////////////////////////////////////////////////////////////////////


		//Repeating Pulse with duration (ms) "pulsedur" and magnitude set by "irrpower[0]" and frequency set by 'pulsefreq' in ?Hz?
		if (block_type == 1 && t >= 10000)
		{
			pulseON +=dt;
			if (pulseON >= (1000/pulsefreq))
			{
			irr = laser;// irrpower[0];
			pulseON = 0;
			pulse_num+=1;
			}
			if (pulseON >= pulsedur)
			{
			irr = 0;
			}
		}
		if (block_type == 2 && t >= 100)//Constant Stim
		{
		irr = laser;
		}

		if (block_type == 3 && t >= 1)//Increasing Pulse Frequency
		{
			pulsefreq = pfmin + (t-1)/(T-1)*(pfmax-pfmin);
			pulseON +=dt;
			if (pulseON >= (1000/pulsefreq))
			{
			irr = irrpower[0];
			pulseON = 0;
			}
			if (pulseON >= pulsedur)
			{
			irr = 0;
			}
		}
		if (block_type == 4)//Constant Stim
		{
		irr=0;
		if(t >= 104000 && t <= 154000){irr = laser;}
		}
		

//////////////////////////////////////////////////////////////////////////////////
//opto stim protocol
//////////////////////////////////////////////////////////////////////////////////


		sp+=pop.step(dt,drive,spk,fcan,fw,fsynCa,irr);






		//output mean population data
		if(int(t/dt)%freq==0) 
		{	
			for(int i=0;i<size;i++){meanVm=meanVm+(pop.net[i].v)/size;}
			out<<(t/1000)<<'\t'<<sp/(.001*DT*size)<<'\t'<<irrpower[0]<<'\t'<<GNAPBLK<<'\t'<<hpV12<<'\t'<<gcan[0]<<'\t'<<irr<<'\t'<<meanVm<<endl;

			sp=0;meanVm=0;
			
		}
		
		//output single neuron data
//		if(int(t/dt)%int(freq/100)==0)
//		{	
			cout<<(t/1000)<<'\t'<<pop.net[0].v<<'\t'<<irr<<'\t'<<pop.net[0].hp<<'\t'<<pop.net[0].hp<<'\t'<<laserpower<<'\t'<<endl;
//		}



	}
   	ofstream os("ini"); os<<pop;
	return 0;
}

